# Distance from the Source (Bellman-Ford Algorithm)
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a weighted, directed and connected graph of V vertices and E edges, Find the shortest distance of all the vertex's from the source vertex S.<br>
<strong>Note: </strong>If the Graph contains a negative cycle then return an array consisting of only -1.</span></p>

<p><span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong>
<img alt="" src="data:image/png;base64,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">
<strong>E </strong>= [[0,1,9]]
<strong>S </strong>= 0
<strong>Output:</strong>
0 9
<strong>Explanation</strong>:
Shortest distance of all nodes from
source is printed.
</span></pre>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong>
<img alt="" src="data:image/png;base64,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">
<strong>E</strong> = [[0,1,5],[1,0,3],[1,2,-1],[2,0,1]]
<strong>S </strong>= 2
<strong>Output:</strong>
1 6 0
<strong>Explanation</strong>:
For nodes 2 to 0, we can follow the path-
2-0. This has a distance of 1.
For nodes 2 to 1, we cam follow the path-
2-0-1, which has a distance of 1+5 = 6,
</span></pre>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Your Task:</strong><br>
You don't need to read input or print anything. Your task is to complete the function <strong>bellman_ford( )</strong>&nbsp;which takes a number of vertices <strong>V</strong><strong> </strong>and<strong> </strong>an<strong> E</strong>-sized list of lists of three integers where the three integers are<strong> u,v</strong>, and <strong>w</strong>; denoting there's an edge from<strong> u to v</strong>, which has a weight of <strong>w</strong> and source node <strong>S</strong>&nbsp;as input parameters and returns a list of integers where the ith integer denotes the distance of an ith node from the source node. </span></p>

<p><span style="font-size:18px">If some node isn't possible to visit, then its distance should be 100000000(1e8). Also, If the Graph contains a negative cycle then return an array consisting of only -1.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Expected Time Complexity:</strong>&nbsp;O(V*E).<br>
<strong>Expected Auxiliary Space:</strong>&nbsp;O(V).</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Constraints:</strong><br>
1 ≤ V ≤ 500<br>
1 ≤ E ≤ V*(V-1)<br>
-1000 ≤ adj[i][j] ≤ 1000<br>
0 ≤ S &lt; V</span></p>
</div>